

create table provincias(
provincia          smallint not null label "Cod. Provincia",
descripcion        char(   20) label "Provincia",
prefijo            smallint label "Prefijo") 
	primary key (provincia)
;


create table formpagos(
formpago           char(    2) not null label "Cod. F.Pago",
descripcion        char(   20) label "Forma de Pago") 
	primary key (formpago)
;


create table unidades(
unidad             char(    2) not null label "Cod. Unidad",
descripcion        char(   10) label "Unidades") 
	primary key (unidad)
;


create table proveedores(
proveedor          integer not null label "Codigo Proveedor",
empresa            char(   25) upshift label "Empresa",
apellidos          char(   25) label "Apellidos",
nombre             char(   15) label "Nombre",
direccion1         char(   25) label "Direccion1",
direccion2         char(   25) label "Direccion2",
poblacion          char(   15) label "Poblacion",
provincia          smallint label "Provincia",
distrito           integer label "Distrito",
telefono           char(   13) label "Telefono") 
	primary key (proveedor)
;
create index i2_proveedor on proveedores(empresa );


create table articulos(
articulo           smallint not null label "Cod. Articulo",
proveedor          integer not null label "Cod. Proveedor",
descripcion        char(   15) label "Descripcion",
pr_vent            money( 9, 2) label "Precio Venta",
pr_cost            money( 9, 2) label "Precio Coste",
existencias        smallint label "Existencias",
sobre_maximo       smallint label "Sobre Maximo",
bajo_minimo        smallint label "Bajo Minimo",
fec_ult_ent        date label "Fecha Ultima Entrada",
fec_ult_sal        date label "Fecha Ultima Salida",
unidad             char(    2) label "Cod. Unidad") 
	primary key (articulo,proveedor)
;
create index i2_articulo on articulos(descripcion );
create index i3_articulo on articulos(articulo );
create index i4_articulo on articulos(proveedor );


create table albaranes(
albaran            integer not null label "Num. Albaran",
cliente            integer not null label "Cod. Cliente",
fecha_albaran      date label "Fecha Albaran",
fecha_envio        date label "Fecha Envio",
fecha_pago         date label "Fecha Pago",
formpago           char(    2) label "Cod. F.Pago",
estado             char(    1) upshift check ($ in ("S", "N")) label "Facturado") 
	primary key (albaran)
;
create index i2_albaran on albaranes(cliente );


create table clientes(
cliente            integer not null label "Codigo Cliente",
empresa            char(   25) upshift label "Empresa",
apellidos          char(   25) label "Apellidos",
nombre             char(   15) label "Nombre",
direccion1         char(   25) label "Direccion1",
direccion2         char(   25) label "Direccion2",
poblacion          char(   15) label "Poblacion",
provincia          smallint label "Provincia",
distrito           integer label "Distrito",
telefono           char(   13) label "Telefono",
formpago           char(    2) label "Forma de Pago",
total_factura      money(11, 2) label "Total Facturado") 
	primary key (cliente)
;
create index i2_cliente on clientes(empresa );


create table lineas(
albaran            integer not null format "###" label "Num. Albaran",
linea              smallint not null format "##" label "Num. Linea",
articulo           smallint label "Cod. Articulo",
proveedor          integer label "Cod. Proveedor",
cantidad           smallint format "###" label "Cantidad",
descuento          smallint label "Descuento",
precio             money( 9, 2) label "Precio") 
	primary key (albaran,linea)
;
create index i_artlineas on lineas(articulo ,proveedor );
create index alblin_ind on lineas(albaran );
alter table proveedores        
	foreign key for1_pro(provincia) 	references provincias
	on update restrict 
	on delete restrict 
;

alter table articulos          
	foreign key for1_art(proveedor) 	references proveedores
	on update restrict 
	on delete restrict 
;

alter table articulos          
	foreign key for2_art(unidad) 	references unidades
	on update restrict 
	on delete restrict 
;

alter table albaranes          
	foreign key for1_alb(cliente) 	references clientes
	on update restrict 
	on delete restrict 
;

alter table albaranes          
	foreign key for2_alb(formpago) 	references formpagos
	on update restrict 
	on delete restrict 
;

alter table clientes           
	foreign key for1_cli(provincia) 	references provincias
	on update restrict 
	on delete restrict 
;

alter table clientes           
	foreign key for2_cli(formpago) 	references formpagos
	on update restrict 
	on delete restrict 
;

alter table lineas             
	foreign key for1_lin(articulo,proveedor) 	references articulos
	on update restrict 
	on delete restrict 
;

alter table lineas             
	foreign key for2_lin(albaran) 	references albaranes
	on update restrict 
	on delete restrict 
;


create view art_facturados(texto, totlinea)
as select
		descripcion,
		sum(precio * (1 - descuento/100) * cantidad) 
	from lineas, articulos, albaranes
	where 
		articulos.articulo = lineas.articulo and
		lineas.proveedor = articulos.proveedor and
		albaranes.albaran = lineas.albaran and
		albaranes.estado = "S"
	group by 1
;

